<?php 
include 'layout_header.php'; 
if($_SESSION['role'] != 'admin'){ echo "<script>window.location='index.php';</script>"; exit; }

// --- PROSES TAMBAH / EDIT BARANG ---
if(isset($_POST['simpan_barang'])){
    $kode = $_POST['kode_barang'];
    $nama = $_POST['nama_barang'];
    $stok = $_POST['stok'];
    $jenis = $_POST['jenis'];
	$keterangan = $_POST['keterangan'];
    
    if(!empty($_POST['id_barang'])){
        // Mode Edit
        $id = $_POST['id_barang'];
        mysqli_query($koneksi, "UPDATE barang SET kode_barang='$kode', nama_barang='$nama', stok='$stok', jenis='$jenis', keterangan='$keterangan' WHERE id='$id'");
        catatLog($koneksi, $_SESSION['user_id'], "Mengedit Barang: $nama");
    } else {
        // Mode Tambah
        mysqli_query($koneksi, "INSERT INTO barang (kode_barang, nama_barang, stok, jenis, keterangan) VALUES ('$kode', '$nama', '$stok', '$jenis', '$keterangan')");
        catatLog($koneksi, $_SESSION['user_id'], "Menambah Barang Baru: $nama");
    }
    echo "<script>alert('Data Barang Disimpan'); window.location='barang.php';</script>";
}

// --- PROSES HAPUS BARANG ---
if(isset($_GET['hapus'])){
    $id = $_GET['hapus'];
    mysqli_query($koneksi, "DELETE FROM barang WHERE id='$id'");
    catatLog($koneksi, $_SESSION['user_id'], "Menghapus Barang ID: $id");
    echo "<script>alert('Barang Dihapus'); window.location='barang.php';</script>";
}
?>

<div class="d-flex">
    <?php include 'layout_sidebar.php'; ?>
    <div class="container-fluid">
        <h2 class="mb-3">Data Barang (Aset & Habis Pakai)</h2>
        
        <button type="button" class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#modalBarang">
            + Tambah Barang
        </button>
		
		<div class="card">
            <div class="card-header bg-secondary text-white">
                Data Barang
            </div>
        <div class="card-body">
        <table class="table table-bordered table-striped table-datatable table-hover">
            <thead class="table-dark">
                <tr>
					<th>No</th>
                    <th>Kode</th>
                    <th>Nama Barang</th>
                    <th>Jenis</th>
                    <th>Stok</th>
                    <th>QR Code</th>
					<th>Keterangan</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php
				$no = 1;
				
                $q = mysqli_query($koneksi, "SELECT * FROM barang ORDER BY id DESC");
                while($d = mysqli_fetch_array($q)){
                    // QR Code
                    $qrContent = "ID:".$d['id']."|Kode:".$d['kode_barang']; 
                    $qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($qrContent);
                    
                    echo "<tr>
						<td>$no</td>
                        <td>{$d['kode_barang']}</td>
                        <td>{$d['nama_barang']}</td>
                        <td>
                            <span class='badge ".($d['jenis']=='Aset'?'bg-success':'bg-warning')."'>{$d['jenis']}</span>
                        </td>
                        <td>{$d['stok']}</td>
                        <td class='text-center'>
                            <img src='$qrUrl' width='50'>
                            <br><a href='$qrUrl' download='QR_{$d['kode_barang']}' target='_blank' style='font-size:10px'>Unduh</a>
                        </td>
						<td>{$d['keterangan']}</td>
                        <td>
                            <button class='btn btn-sm btn-warning btn-edit' 
                                data-id='{$d['id']}' data-kode='{$d['kode_barang']}' 
                                data-nama='{$d['nama_barang']}' data-stok='{$d['stok']}' 
                                data-jenis='{$d['jenis']}'>Ubah</button>
                            <a href='barang.php?hapus={$d['id']}' class='btn btn-sm btn-danger' onclick='return confirm(\"Yakin hapus?\")'>Hapus</a>
                        </td>
                    </tr>";
					$no++;
                }
                ?>
            </tbody>
        </table>
		</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modalBarang" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Form Barang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id_barang" id="id_barang">
                    <div class="mb-3">
                        <label>Kode Barang (Unik)</label>
                        <input type="text" name="kode_barang" id="kode_barang" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Nama Barang</label>
                        <input type="text" name="nama_barang" id="nama_barang" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Jenis</label>
                        <select name="jenis" id="jenis" class="form-select">
                            <option value="Aset">Aset (Wajib Kembali)</option>
                            <option value="Habis Pakai">Habis Pakai (Sekali Pakai)</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Stok Awal</label>
                        <input type="number" name="stok" id="stok" class="form-control" required>
                    </div>
					<div class="mb-3">
						<label>Keterangan (Opsional)</label>
						<textarea name="keterangan" id="keterangan" class="form-control"></textarea>
					</div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="simpan_barang" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Script untuk mengisi modal saat tombol Edit diklik
$('.btn-edit').click(function(){
    $('#modalBarang').modal('show');
    $('#id_barang').val($(this).data('id'));
    $('#kode_barang').val($(this).data('kode'));
    $('#nama_barang').val($(this).data('nama'));
    $('#stok').val($(this).data('stok'));
    $('#jenis').val($(this).data('jenis'));
});
// Reset modal saat ditutup
$('#modalBarang').on('hidden.bs.modal', function () {
    $('form')[0].reset();
    $('#id_barang').val('');
});
</script>

<?php include 'layout_footer.php'; ?>