<?php
include 'koneksi.php'; // Hanya butuh koneksi, tidak butuh layout header/sidebar
cekLogin();

$tgl_awal = $_GET['awal'];
$tgl_akhir = $_GET['akhir'];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Cetak Laporan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* CSS Khusus Cetak */
        body { font-family: "Times New Roman", Times, serif; }
        .header { text-align: center; margin-bottom: 20px; border-bottom: 3px double black; padding-bottom: 10px; }
        .ttd-area { margin-top: 50px; display: flex; justify-content: space-between; padding: 0 50px; }
        .ttd-box { text-align: center; }
        @media print {
            @page { size: A4; margin: 2cm; }
            .no-print { display: none; }
        }
    </style>
</head>
<body onload="window.print()">

    <div class="container mt-4">
        <div class="header">
            <h3>LAPORAN PEMINJAMAN ALAT LABORATORIUM TKJ</h3>
            <h5>SMK/Kampus ... (Isi Nama Sekolah Disini) ...</h5>
            <p class="m-0">Periode: <?= date('d-m-Y', strtotime($tgl_awal)) ?> s/d <?= date('d-m-Y', strtotime($tgl_akhir)) ?></p>
        </div>

        <table class="table table-bordered table-sm border-dark">
            <thead>
                <tr class="table-secondary border-dark">
                    <th>No</th>
                    <th>Nama Peminjam</th>
                    <th>Nama Barang</th>
                    <th>Jml</th>
                    <th>Tgl Pinjam</th>
                    <th>Tgl Kembali</th>
                    <th>Status</th>
                    <th>Petugas</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $no = 1;
                $sql = "SELECT t.*, p.nama_lengkap, b.nama_barang, u.nama_user 
                        FROM transaksi t 
                        JOIN peminjam p ON t.id_peminjam=p.id 
                        JOIN barang b ON t.id_barang=b.id 
                        LEFT JOIN users u ON t.petugas_pinjam=u.id
                        WHERE DATE(t.tgl_pinjam) BETWEEN '$tgl_awal' AND '$tgl_akhir'
                        ORDER BY t.tgl_pinjam ASC";
                $q = mysqli_query($koneksi, $sql);
                while($d = mysqli_fetch_array($q)){
                    $tgl_kembali = $d['tgl_kembali'] ? date('d-m-Y', strtotime($d['tgl_kembali'])) : '-';
                    $tgl_pinjam = date('d-m-Y', strtotime($d['tgl_pinjam']));
                    
                    echo "<tr>
                        <td class='text-center'>$no</td>
                        <td>{$d['nama_lengkap']}</td>
                        <td>{$d['nama_barang']}</td>
                        <td class='text-center'>{$d['jumlah']}</td>
                        <td>$tgl_pinjam</td>
                        <td>$tgl_kembali</td>
                        <td>{$d['status']}</td>
                        <td>{$d['nama_user']}</td>
                    </tr>";
                    $no++;
                }
                ?>
            </tbody>
        </table>

        <div class="ttd-area">
            <div class="ttd-box">
                <p>Mengetahui,<br>Kepala Laboratorium</p>
                <br><br><br>
                <p><strong>( _______________________ )</strong><br>NIP. .........................</p>
            </div>
            <div class="ttd-box">
                <p>......, <?= date('d F Y') ?><br>Petugas Lab</p>
                <br><br><br>
                <p><strong><?= $_SESSION['nama_user'] ?></strong></p>
            </div>
        </div>
    </div>

</body>
</html>