<?php include 'layout_header.php'; ?>
<div class="d-flex">
    <?php include 'layout_sidebar.php'; ?>
    <div class="container-fluid">
        <h2 class="mb-4">History Peminjaman & Pengembalian</h2>
        
		<div class="card">
            <div class="card-header bg-secondary text-white">
                History Peminjaman Barang
            </div>
        <div class="card-body">
        <table class="table table-striped table-bordered table-datatable"">
            <thead class="table-dark">
                <tr>
					<th>No</th>
                    <th>Peminjam</th>
                    <th>Barang</th>
                    <th>Jumlah</th>
                    <th>Tgl Pinjam (Petugas)</th>
                    <th>Tgl Kembali (Petugas)</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php
				$no = 1;
                // Join ke tabel users 2x (untuk petugas pinjam & petugas kembali)
                $query = "SELECT t.*, 
                                 p.nama_lengkap, 
                                 b.nama_barang,
                                 u1.nama_user AS ptgs_pinjam,
                                 u2.nama_user AS ptgs_kembali
                          FROM transaksi t
                          JOIN peminjam p ON t.id_peminjam = p.id
                          JOIN barang b ON t.id_barang = b.id
                          LEFT JOIN users u1 ON t.petugas_pinjam = u1.id
                          LEFT JOIN users u2 ON t.petugas_kembali = u2.id
                          ORDER BY t.tgl_pinjam DESC"; // Saya ubah sort by tgl pinjam DESC agar history terbaru diatas
                          
                $q = mysqli_query($koneksi, $query);
                while($d = mysqli_fetch_array($q)){
                    
                    // --- LOGIKA WARNA STATUS ---
                    $warna_status = 'bg-secondary'; // Default (abu-abu)
                    if($d['status'] == 'Kembali'){
                        $warna_status = 'bg-success'; // Hijau
                    } elseif($d['status'] == 'Dipinjam'){
                        $warna_status = 'bg-warning text-dark'; // Kuning (pakai text-dark biar tulisan jelas)
                    } elseif($d['status'] == 'Keluar'){
                        $warna_status = 'bg-danger'; // Merah
                    }

                    // Format tanggal agar rapi (Opsional, biar tidak hanya angka)
                    $tgl_pinjam = date('d-m-Y H:i', strtotime($d['tgl_pinjam']));
                    $tgl_kembali = $d['tgl_kembali'] ? date('d-m-Y H:i', strtotime($d['tgl_kembali'])) : '-';

                    echo "<tr>
						<td>$no</td>
                        <td>{$d['nama_lengkap']}</td>
                        <td>{$d['nama_barang']}</td>
                        <td>{$d['jumlah']}</td>
                        <td>$tgl_pinjam <br><small class='text-muted'>by {$d['ptgs_pinjam']}</small></td>
                        <td>$tgl_kembali <br><small class='text-muted'>by {$d['ptgs_kembali']}</small></td>
                        <td>
                            <span class='badge $warna_status'>{$d['status']}</span>
                        </td>
                    </tr>";
					$no++;
                }
                ?>
            </tbody>
        </table>
		</div>
		</div>
    </div>
</div>
<?php include 'layout_footer.php'; ?>