<?php include 'layout_header.php'; ?>
<div class="d-flex">
    <?php include 'layout_sidebar.php'; ?>
    
    <div class="container-fluid">
        <h2 class="mb-4">Dashboard & Informasi</h2>
        
        <div class="col-md-4">
		<div class="card text-white bg-primary mb-3">
        <div class="card-body">
            <h5 class="card-title">Barang Dipinjam</h5>
            <?php 
            // Hitung SUM jumlah, bukan COUNT row
            $sql = mysqli_query($koneksi, "SELECT SUM(jumlah) as total FROM transaksi WHERE status='Dipinjam'");
            $data = mysqli_fetch_assoc($sql);
            $total = $data['total'] ? $data['total'] : 0;
            ?>
            <p class="display-4"><?= $total ?> Unit</p>
            <a href="transaksi.php" class="text-white text-decoration-none">Lihat Detail ></a>
        </div>
		</div>
		</div>

        <div class="card">
            <div class="card-header bg-warning">
                <strong>⚠️ Status Barang Sedang Dipinjam</strong>
            </div>
            <div class="card-body">
                <table class="table table-striped table-hover table-datatable">
                    <thead class="table-dark">
                        <tr>
							<th>No</th>
                            <th>Nama Peminjam</th>
                            <th>Status</th>
                            <th>Barang</th>
							<th>Jml Barang</th>
                            <th>Tgl Pinjam</th>
                            <th>Durasi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
						$no = 1;
                        // Join tabel transaksi, peminjam, barang
                        $q = mysqli_query($koneksi, "
                            SELECT t.*, p.nama_lengkap, p.status_peminjam, b.nama_barang 
                            FROM transaksi t
                            JOIN peminjam p ON t.id_peminjam = p.id
                            JOIN barang b ON t.id_barang = b.id
                            WHERE t.status = 'Dipinjam'
                            ORDER BY t.tgl_pinjam ASC
                        ");
                        while($d = mysqli_fetch_array($q)){
                            // Hitung durasi hari
                            $tgl1 = new DateTime($d['tgl_pinjam']);
                            $tgl2 = new DateTime();
                            $jarak = $tgl2->diff($tgl1);
                            echo "<tr>
								<td>$no</td>
                                <td>{$d['nama_lengkap']}</td>
                                <td><span class='badge bg-secondary'>{$d['status_peminjam']}</span></td>
                                <td>{$d['nama_barang']}</td>
								<td>{$d['jumlah']}</td>
                                <td>{$d['tgl_pinjam']}</td>
                                <td>{$jarak->d} Hari</td>
                            </tr>";
							$no++;
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
</div> </body>
</html>

<?php include 'layout_footer.php'; ?>