
<?php 
include 'layout_header.php'; 

// Default tanggal: Awal bulan ini sampai hari ini
$tgl_awal = date('Y-m-01');
$tgl_akhir = date('Y-m-d');

if(isset($_POST['filter'])){
    $tgl_awal = $_POST['tgl_awal'];
    $tgl_akhir = $_POST['tgl_akhir'];
}
?>

<div class="d-flex">
    <?php include 'layout_sidebar.php'; ?>
    <div class="container-fluid">
        <h2 class="mb-4">Laporan Peminjaman</h2>
        
        <div class="card mb-4 no-print">
            <div class="card-body">
                <form method="POST" class="row g-3 align-items-end">
                    <div class="col-auto">
                        <label>Dari Tanggal</label>
                        <input type="date" name="tgl_awal" class="form-control" value="<?= $tgl_awal ?>" required>
                    </div>
                    <div class="col-auto">
                        <label>Sampai Tanggal</label>
                        <input type="date" name="tgl_akhir" class="form-control" value="<?= $tgl_akhir ?>" required>
                    </div>
                    <div class="col-auto">
                        <button type="submit" name="filter" class="btn btn-primary">Tampilkan</button>
                        <a href="cetak_laporan.php?awal=<?= $tgl_awal ?>&akhir=<?= $tgl_akhir ?>" target="_blank" class="btn btn-danger">
                            🖨️ Cetak PDF
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header bg-secondary text-white">
                Preview Laporan (<?= $tgl_awal ?> s/d <?= $tgl_akhir ?>)
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-datatable">
                    <thead class="table-dark">
                        <tr>
                            <th>No</th>
                            <th>Peminjam</th>
                            <th>Barang</th>
                            <th>Jml</th>
                            <th>Tgl Pinjam</th>
                            <th>Tgl Kembali</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        // Filter berdasarkan range tanggal pinjam
                        $sql = "SELECT t.*, p.nama_lengkap, b.nama_barang 
                                FROM transaksi t 
                                JOIN peminjam p ON t.id_peminjam=p.id 
                                JOIN barang b ON t.id_barang=b.id 
                                WHERE DATE(t.tgl_pinjam) BETWEEN '$tgl_awal' AND '$tgl_akhir'
                                ORDER BY t.tgl_pinjam ASC";
                        $q = mysqli_query($koneksi, $sql);
                        while($d = mysqli_fetch_array($q)){
                            $tgl_kembali = $d['tgl_kembali'] ? $d['tgl_kembali'] : '-';
                            echo "<tr>
                                <td>$no</td>
                                <td>{$d['nama_lengkap']}</td>
                                <td>{$d['nama_barang']}</td>
                                <td>{$d['jumlah']}</td>
                                <td>{$d['tgl_pinjam']}</td>
                                <td>$tgl_kembali</td>
                                <td>{$d['status']}</td>
                            </tr>";
                            $no++;
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include 'layout_footer.php'; ?>