<?php 
include 'layout_header.php'; 
if($_SESSION['role'] != 'admin'){ echo "<script>window.location='index.php';</script>"; exit; }

// --- DOWNLOAD TEMPLATE ---
if(isset($_GET['download_template'])){
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="template_peminjam.csv"');
    $out = fopen('php://output', 'w');
    fputcsv($out, array('No Induk', 'Nama Lengkap', 'Status (Siswa/Guru)'));
    fputcsv($out, array('12345', 'Contoh Siswa', 'Siswa'));
    fclose($out);
    exit;
}

// --- PROSES IMPORT ---
if(isset($_POST['import_data'])){
    $file = fopen($_FILES['file_csv']['tmp_name'], "r");
    fgetcsv($file); // Skip header
    while(($row = fgetcsv($file, 10000, ",")) !== FALSE){
        if(!empty($row[0])) mysqli_query($koneksi, "INSERT IGNORE INTO peminjam (no_induk, nama_lengkap, status_peminjam) VALUES ('$row[0]', '$row[1]', '$row[2]')");
    }
    catatLog($koneksi, $_SESSION['user_id'], "Import Data Peminjam");
    echo "<script>alert('Import Selesai'); window.location='peminjam.php';</script>";
}

// --- PROSES SIMPAN (TAMBAH / UBAH) ---
if(isset($_POST['simpan_peminjam'])){
    $id = $_POST['id_peminjam'];
    $induk = $_POST['no_induk'];
    $nama = $_POST['nama_lengkap'];
    $status = $_POST['status_peminjam'];

    if(empty($id)){
        // INSERT
        $q = mysqli_query($koneksi, "INSERT INTO peminjam (no_induk, nama_lengkap, status_peminjam) VALUES ('$induk', '$nama', '$status')");
        if($q) catatLog($koneksi, $_SESSION['user_id'], "Tambah Peminjam: $nama");
        else echo "<script>alert('Gagal! NIS/NIP mungkin sudah dipakai.');</script>";
    } else {
        // UPDATE
        mysqli_query($koneksi, "UPDATE peminjam SET no_induk='$induk', nama_lengkap='$nama', status_peminjam='$status' WHERE id='$id'");
        catatLog($koneksi, $_SESSION['user_id'], "Ubah Peminjam: $nama");
    }
    echo "<script>window.location='peminjam.php';</script>";
}

// --- PROSES HAPUS ---
if(isset($_GET['hapus'])){
    mysqli_query($koneksi, "DELETE FROM peminjam WHERE id='".$_GET['hapus']."'");
    catatLog($koneksi, $_SESSION['user_id'], "Hapus Peminjam ID: ".$_GET['hapus']);
    echo "<script>window.location='peminjam.php';</script>";
}
?>

<div class="d-flex">
    <?php include 'layout_sidebar.php'; ?>
    <div class="container-fluid">
        <h2 class="mb-3">Data Peminjam</h2>
        
        <div class="row mb-3">
            <div class="col-md-6">
                <button class="btn btn-primary" onclick="resetModal()">+ Tambah Peminjam Manual</button>
            </div>
            <div class="col-md-6 text-end">
                <form method="POST" enctype="multipart/form-data" class="d-flex justify-content-end gap-2">
                    <input type="file" name="file_csv" class="form-control form-control-sm w-50" required>
                    <button type="submit" name="import_data" class="btn btn-sm btn-success">Import CSV</button>
                    <a href="peminjam.php?download_template=true" class="btn btn-sm btn-outline-secondary">Template</a>
                </form>
            </div>
        </div>
		
		<div class="card">
            <div class="card-header bg-secondary text-white">
                Data Siswa dan Guru
            </div>
        <div class="card-body">
        <table class="table table-striped table-bordered table-hover table-datatable">
            <thead class="table-dark">
                <tr>
				<th>No</th>
				<th>No Induk</th>
				<th>Nama Lengkap</th>
				<th>Status</th>
				<th>Aksi</th>
				</tr>
            </thead>
            <tbody>
                <?php
				$no = 1;
				
                $q = mysqli_query($koneksi, "SELECT * FROM peminjam ORDER BY id DESC");
                while($d = mysqli_fetch_array($q)){
                    echo "<tr>
						<td>$no</td>
                        <td>{$d['no_induk']}</td>
                        <td>{$d['nama_lengkap']}</td>
                        <td>{$d['status_peminjam']}</td>
                        <td>
                            <button class='btn btn-warning btn-sm btn-edit' 
                                data-id='{$d['id']}' 
                                data-induk='{$d['no_induk']}' 
                                data-nama='{$d['nama_lengkap']}' 
                                data-status='{$d['status_peminjam']}'>Ubah</button>
                            <a href='peminjam.php?hapus={$d['id']}' class='btn btn-danger btn-sm' onclick='return confirm(\"Hapus?\")'>Hapus</a>
                        </td>
                    </tr>";
					$no++;
                }
                ?>
            </tbody>
        </table>
		</div>
		</div>
    </div>
</div>

<div class="modal fade" id="modalPeminjam">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title" id="modalTitle">Form Peminjam</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id_peminjam" id="id_peminjam">
                    <div class="mb-3">
                        <label>No. Induk (NIS/NIP)</label>
                        <input type="text" name="no_induk" id="no_induk" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Nama Lengkap</label>
                        <input type="text" name="nama_lengkap" id="nama_lengkap" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Status</label>
                        <select name="status_peminjam" id="status_peminjam" class="form-select">
                            <option value="Siswa">Siswa</option>
                            <option value="Guru">Guru</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="simpan_peminjam" class="btn btn-primary">Simpan Data</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Fungsi Reset Modal untuk Tambah Baru
function resetModal(){
    $('#modalPeminjam').modal('show');
    $('#modalTitle').text('Tambah Peminjam');
    $('form')[1].reset(); // Index 1 karena ada form import di index 0
    $('#id_peminjam').val('');
}

// Fungsi Isi Modal untuk Edit
$('.btn-edit').click(function(){
    $('#modalPeminjam').modal('show');
    $('#modalTitle').text('Ubah Peminjam');
    $('#id_peminjam').val($(this).data('id'));
    $('#no_induk').val($(this).data('induk'));
    $('#nama_lengkap').val($(this).data('nama'));
    $('#status_peminjam').val($(this).data('status'));
});
</script>

<?php include 'layout_footer.php'; ?>