<?php 
include 'layout_header.php'; 

// --- PROSES PINJAM (DENGAN VALIDASI) ---
if(isset($_POST['simpan_transaksi'])){
    $id_peminjam = $_POST['id_peminjam_hidden'];
    $id_barang   = $_POST['id_barang_hidden']; 
    $jumlah      = (int)$_POST['jumlah'];
    $petugas     = $_SESSION['user_id'];
    
    // 1. Validasi: Apakah Nama Peminjam Valid (Ada di database)?
    if(empty($id_peminjam)){
        echo "<script>alert('ERROR: Nama Peminjam tidak ditemukan dalam sistem! Harap pilih dari daftar sugesti saat mengetik.'); window.location='transaksi.php';</script>";
        exit;
    }

    // 2. Validasi: Apakah Barang Valid?
    if(empty($id_barang)){
        echo "<script>alert('ERROR: Nama Barang tidak ditemukan dalam sistem! Harap pilih dari daftar sugesti.'); window.location='transaksi.php';</script>";
        exit;
    }

    // Ambil data barang & peminjam untuk validasi lanjutan & Log
    $cekBrg = mysqli_fetch_array(mysqli_query($koneksi, "SELECT * FROM barang WHERE id='$id_barang'"));
    $cekOrg = mysqli_fetch_array(mysqli_query($koneksi, "SELECT * FROM peminjam WHERE id='$id_peminjam'"));
    $namaPinjam = $cekOrg['nama_lengkap'];

    // 3. Validasi Stok
    if($jumlah > $cekBrg['stok']){
        echo "<script>alert('ERROR: Jumlah yang ingin dipinjam ({$jumlah}) melebihi stok yang tersedia ({$cekBrg['stok']})!'); window.location='transaksi.php';</script>";
        exit;
    }

    // Jika Lolos Semua Validasi -> Simpan
    $status = ($cekBrg['jenis'] == 'Habis Pakai') ? 'Keluar' : 'Dipinjam';
    mysqli_query($koneksi, "INSERT INTO transaksi (id_peminjam, id_barang, jumlah, petugas_pinjam, status) VALUES ('$id_peminjam', '$id_barang', '$jumlah', '$petugas', '$status')");
    mysqli_query($koneksi, "UPDATE barang SET stok = stok - $jumlah WHERE id='$id_barang'");
    
    catatLog($koneksi, $petugas, "Meminjamkan {$cekBrg['nama_barang']} (Jml: $jumlah) ke $namaPinjam");
    echo "<script>alert('Transaksi Berhasil Disimpan!'); window.location='transaksi.php';</script>";
}

// ... (Kode Proses Pengembalian Tetap Sama seperti sebelumnya) ...
// Copy paste kode if(isset($_POST['proses_kembali'])) dari jawaban sebelumnya di sini
if(isset($_POST['proses_kembali'])){
    $id_trans   = $_POST['id_transaksi_kembali'];
    $jml_kembali= (int)$_POST['jumlah_kembali'];
    $petugas    = $_SESSION['user_id'];
    
    $dt = mysqli_fetch_array(mysqli_query($koneksi, "SELECT t.*, b.nama_barang, p.nama_lengkap FROM transaksi t JOIN barang b ON t.id_barang=b.id JOIN peminjam p ON t.id_peminjam=p.id WHERE t.id='$id_trans'"));
    $sisa_pinjam = $dt['jumlah'] - $jml_kembali;

    if($sisa_pinjam == 0){
        mysqli_query($koneksi, "UPDATE transaksi SET tgl_kembali=NOW(), status='Kembali', petugas_kembali='$petugas' WHERE id='$id_trans'");
    } else {
        mysqli_query($koneksi, "UPDATE transaksi SET jumlah='$sisa_pinjam' WHERE id='$id_trans'");
        $id_p = $dt['id_peminjam']; $id_b = $dt['id_barang']; $tgl_p = $dt['tgl_pinjam']; $petugas_p = $dt['petugas_pinjam'];
        $sqlBaru = "INSERT INTO transaksi (id_peminjam, id_barang, jumlah, tgl_pinjam, tgl_kembali, status, petugas_pinjam, petugas_kembali) VALUES ('$id_p', '$id_b', '$jml_kembali', '$tgl_p', NOW(), 'Kembali', '$petugas_p', '$petugas')";
        mysqli_query($koneksi, $sqlBaru);
    }
    mysqli_query($koneksi, "UPDATE barang SET stok = stok + $jml_kembali WHERE id='{$dt['id_barang']}'");
    catatLog($koneksi, $petugas, "Menerima Kembali {$dt['nama_barang']} (Jml: $jml_kembali) dari {$dt['nama_lengkap']}");
    echo "<script>alert('Pengembalian Berhasil!'); window.location='transaksi.php';</script>";
}
?>

<div class="d-flex">
    <?php include 'layout_sidebar.php'; ?>
    <div class="container-fluid">
        <h2 class="mb-4">Transaksi Peminjaman</h2>
        
        <div class="card mb-4 border-primary">
            <div class="card-body">
                <form method="POST">
                    <div class="row">
                        <div class="col-md-5">
                            <label>Peminjam (Siswa/Guru)</label>
                            <input type="text" id="nama_peminjam" class="form-control" placeholder="Ketik Nama..." required>
                            <input type="hidden" name="id_peminjam_hidden" id="id_peminjam_hidden">
                            <small class="text-danger" id="err_peminjam" style="display:none;">*Pilih nama dari daftar yang muncul!</small>
                        </div>
                        <div class="col-md-5">
                            <label>Nama Barang</label>
                            <input type="text" id="nama_barang" class="form-control" placeholder="Ketik Nama Barang..." required>
                            <input type="hidden" name="id_barang_hidden" id="id_barang_hidden">
                            <small class="text-danger" id="err_barang" style="display:none;">*Pilih barang dari daftar yang muncul!</small>
                        </div>
                        <div class="col-md-2">
                            <label>Jumlah</label>
                            <input type="number" name="jumlah" class="form-control" min="1" value="1">
                        </div>
                    </div>
                    <button type="submit" name="simpan_transaksi" class="btn btn-success mt-3">Proses Pinjam</button>
                </form>
            </div>
        </div>

        <h4>Sedang Dipinjam</h4>
        <div class="card">
            <div class="card-body">
                <table class="table table-bordered table-hover table-datatable">
                    <thead class="table-dark">
                        <tr>
						<th>No</th>
						<th>Peminjam</th>
						<th>Barang</th>
						<th>Jml</th>
						<th>Tgl Pinjam</th>
						<th>Aksi</th></tr>
                    </thead>
                    <tbody>
                        <?php
						$no = 1;
                        $q = mysqli_query($koneksi, "SELECT t.*, p.nama_lengkap, b.nama_barang FROM transaksi t JOIN peminjam p ON t.id_peminjam=p.id JOIN barang b ON t.id_barang=b.id WHERE t.status='Dipinjam' ORDER BY t.id DESC");
                        while($r = mysqli_fetch_array($q)){
                            echo "<tr>
								<td>$no</td>
                                <td>{$r['nama_lengkap']}</td>
                                <td>{$r['nama_barang']}</td>
                                <td>{$r['jumlah']}</td>
                                <td>{$r['tgl_pinjam']}</td>
                                <td>
                                    <button class='btn btn-warning btn-sm btn-kembali' 
                                        data-id='{$r['id']}' data-barang='{$r['nama_barang']}' 
                                        data-jumlah='{$r['jumlah']}'>Kembalikan</button>
                                </td>
                            </tr>";
							$no++;
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalKembali">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Pengembalian Barang</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id_transaksi_kembali" id="id_transaksi_kembali">
                    <p>Barang: <b id="lbl_barang"></b> | Total Pinjam: <b id="lbl_jumlah"></b></p>
                    <div class="mb-3">
                        <label>Jumlah yang dikembalikan:</label>
                        <input type="number" name="jumlah_kembali" id="jumlah_kembali" class="form-control" required min="1">
                    </div>
                </div>
                <div class="modal-footer"><button type="submit" name="proses_kembali" class="btn btn-success">Proses</button></div>
            </form>
        </div>
    </div>
</div>

<script>
// Logic JS: Jika user mengetik lalu menghapus teks, ID Hidden juga harus dihapus
// agar validasi PHP bekerja.

$("#nama_barang").autocomplete({
    source: "ajax_barang.php",
    select: function(event, ui){ 
        $("#id_barang_hidden").val(ui.item.id); 
        $("#err_barang").hide();
    },
    change: function(event, ui){
        if(!ui.item){
            $(this).val(""); // Kosongkan input text
            $("#id_barang_hidden").val(""); // Kosongkan ID
            $("#err_barang").show(); // Tampilkan pesan error kecil
        }
    }
});

$("#nama_peminjam").autocomplete({
    source: "ajax_peminjam.php",
    select: function(event, ui){ 
        $("#id_peminjam_hidden").val(ui.item.id); 
        $("#err_peminjam").hide();
    },
    change: function(event, ui){
        if(!ui.item){
            $(this).val(""); 
            $("#id_peminjam_hidden").val("");
            $("#err_peminjam").show();
        }
    }
});

$('.btn-kembali').click(function(){
    $('#modalKembali').modal('show');
    $('#id_transaksi_kembali').val($(this).data('id'));
    $('#lbl_barang').text($(this).data('barang'));
    $('#lbl_jumlah').text($(this).data('jumlah'));
    $('#jumlah_kembali').val($(this).data('jumlah'));
    $('#jumlah_kembali').attr('max', $(this).data('jumlah'));
});
</script>

<?php include 'layout_footer.php'; ?>